   float4 VertexFog(in float Depth, in float3 WorldPos, in float3 ViewVec, in float3 LightDirection, in float3 LightDirectionColor, in float4 FogColor, in float3 FogDensity, in float4 FogHeightColor, in float4 FogHeight)
      {
         float3 FogDist=float3(Depth.xx,WorldPos.y-FogHeight.x)/float3(FogColor.w,FogHeightColor.w,FogHeight.y);
         FogDist=1.0-saturate((exp(-FogDensity.x*FogDist)-FogDensity.y)*FogDensity.z);
         float3 Fog=lerp(FogColor.xyz,LightDirectionColor*0.5,pow(max(dot(ViewVec,-LightDirection),0.0),2.0));
         Fog=lerp(FogHeightColor.xyz,Fog,FogDist.x);
         return float4(Fog,max(FogDist.x,FogDist.y*(1.0-FogDist.z)));
      }